<?php
require_once __DIR__ . '/../src/Payroll.php';
$payroll = new Payroll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    foreach ($_POST['config'] as $key => $val) {
        $payroll->updateConfig($key, $val);
    }
    $success = "Configuration updated successfully.";
}

$config = $payroll->getConfig();
?>
<div class="card" style="max-width: 600px;">
    <h2>Payroll Configuration</h2>
    <?php if(isset($success)): ?><div style="color: green; margin-bottom: 10px;"><?php echo $success; ?></div><?php endif; ?>
    
    <form method="POST">
        <div class="form-group">
            <label>House Rent (%)</label>
            <input type="number" name="config[house_rent_percent]" value="<?php echo $config['house_rent_percent']; ?>" class="form-control">
        </div>
        <div class="form-group">
            <label>Medical Allowance (Fixed)</label>
            <input type="number" name="config[medical_allowance]" value="<?php echo $config['medical_allowance']; ?>" class="form-control">
        </div>
        <div class="form-group">
            <label>Conveyance Allowance (Fixed)</label>
            <input type="number" name="config[conveyance_allowance]" value="<?php echo $config['conveyance_allowance']; ?>" class="form-control">
        </div>
        <div class="form-group">
            <label>Provident Fund (Employee Share %)</label>
            <input type="number" name="config[pf_employee_percent]" value="<?php echo $config['pf_employee_percent']; ?>" class="form-control">
        </div>
        <button type="submit" style="background: #2563eb; color: white; padding: 10px 20px; border: none; border-radius: 4px; cursor: pointer;">Update Settings</button>
    </form>
</div>
