<?php
require_once __DIR__ . '/../src/Payroll.php';
$payroll = new Payroll();
$month = isset($_GET['month']) ? $_GET['month'] : date('n');
$year = isset($_GET['year']) ? $_GET['year'] : date('Y');

// Handle Process Action
if (isset($_POST['process'])) {
    $payroll->generateFinalSalary($month, $year);
    $success = "Salary processed successfully!";
}

$sheet = $payroll->getSalarySheet($month, $year);
?>

<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem;">
    <h2>Salary Sheet - <?php echo date('F Y', mktime(0, 0, 0, $month, 10, $year)); ?></h2>
    <div style="display: flex; gap: 10px;">
        <form method="POST" onsubmit="return confirm('Are you sure you want to process salary? This will overwrite previous values.');">
            <button type="submit" name="process" style="background: #d97706; color: white; padding: 8px 16px; border: none; border-radius: 4px; cursor: pointer;">Process Salary</button>
        </form>
        <button onclick="window.print()" style="background: #4b5563; color: white; padding: 8px 16px; border: none; border-radius: 4px; cursor: pointer;">Print PDF</button>
    </div>
</div>

<?php if(isset($success)): ?>
    <div style="background: #dcfce7; color: green; padding: 10px; margin-bottom: 10px;"><?php echo $success; ?></div>
<?php endif; ?>

<div class="card" style="overflow-x: auto;">
    <table style="font-size: 0.85rem;">
        <thead>
            <tr style="background: #1f2937; color: white;">
                <th>ID</th>
                <th>Name</th>
                <th>Basic</th>
                <th>H.Rent (75%)</th>
                <th>Med</th>
                <th>Conv</th>
                <th>Special (5%)</th>
                <th>Variable</th>
                <th>GROSS</th>
                <th>PF (10%)</th>
                <th>Deduct</th>
                <th>NET PAY</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $total_net = 0;
            foreach($sheet as $row): 
                $gross = $row['basic_salary'] + $row['house_rent'] + $row['medical'] + $row['conveyance'] + $row['special_allowance'] + $row['variable_allowance'];
                $deducts = $row['pf_deduction'] + $row['other_deductions'];
                $total_net += $row['net_pay'];
            ?>
            <tr>
                <td><?php echo $row['emp_code']; ?></td>
                <td>
                    <b><?php echo $row['full_name']; ?></b><br>
                    <span style="color: grey;"><?php echo $row['designation']; ?></span>
                </td>
                <td><?php echo number_format($row['basic_salary']); ?></td>
                <td><?php echo number_format($row['house_rent']); ?></td>
                <td><?php echo number_format($row['medical']); ?></td>
                <td><?php echo number_format($row['conveyance']); ?></td>
                <td><?php echo number_format($row['special_allowance']); ?></td>
                <td><?php echo number_format($row['variable_allowance']); ?></td>
                <td style="font-weight: bold; background: #f3f4f6;"><?php echo number_format($gross); ?></td>
                <td style="color: #b91c1c;"><?php echo number_format($row['pf_deduction']); ?></td>
                <td style="color: #b91c1c;"><?php echo number_format($row['other_deductions']); ?></td>
                <td style="font-weight: bold; background: #dcfce7; color: #166534;"><?php echo number_format($row['net_pay']); ?></td>
            </tr>
            <?php endforeach; ?>
            <tr style="font-weight: bold; background: #e5e7eb;">
                <td colspan="11" style="text-align: right;">Total Net Payable:</td>
                <td><?php echo number_format($total_net); ?></td>
            </tr>
        </tbody>
    </table>
</div>

<style>
@media print {
    body * { visibility: hidden; }
    .card, .card * { visibility: visible; }
    .card { position: absolute; left: 0; top: 0; width: 100%; box-shadow: none; }
    .sidebar, .topbar { display: none; }
}
</style>
