<?php
require_once __DIR__ . '/../src/Leave.php';
$leave = new Leave();

// Logic: If Admin/Manager, show Pending Applications. If Employee, show My History.
$is_manager = $auth->hasRole('hr_admin') || $auth->hasRole('branch_manager') || $auth->hasRole('executive_director');
?>

<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem;">
    <h2>Leave Applications</h2>
    <a href="index.php?action=leave_apply" class="btn" style="background: #2563eb; color: white; padding: 8px 16px; text-decoration: none; border-radius: 4px;">Apply for Leave</a>
</div>

<?php if($is_manager): 
    $pending = $leave->getPendingLeaves($auth->hasRole('branch_manager') ? $_SESSION['branch_id'] : null);
?>
<div class="card">
    <h3>Pending Approvals</h3>
    <?php if(empty($pending)): ?>
        <p>No pending applications.</p>
    <?php else: ?>
        <table>
            <thead>
                <tr>
                    <th>Employee</th>
                    <th>Type</th>
                    <th>Dates</th>
                    <th>Reason</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($pending as $p): ?>
                <tr>
                    <td><?php echo htmlspecialchars($p['full_name']); ?></td>
                    <td><?php echo htmlspecialchars($p['type']); ?></td>
                    <td><?php echo $p['start_date'] . ' to ' . $p['end_date']; ?></td>
                    <td><?php echo htmlspecialchars($p['reason']); ?></td>
                    <td>
                        <a href="index.php?action=leave_approve&id=<?php echo $p['id']; ?>" style="color: green; margin-right: 10px;">Approve</a>
                        <a href="index.php?action=leave_reject&id=<?php echo $p['id']; ?>" style="color: red;">Reject</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>
<?php endif; ?>

<div class="card">
    <h3>My Leave History</h3>
    <table>
        <thead>
            <tr>
                <th>Type</th>
                <th>Dates</th>
                <th>Status</th>
                <th>Reason</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $my_leaves = $leave->getMyLeaves($_SESSION['user_id']);
            foreach($my_leaves as $ml): 
            ?>
            <tr>
                <td><?php echo htmlspecialchars($ml['type']); ?></td>
                <td><?php echo $ml['start_date'] . ' to ' . $ml['end_date']; ?></td>
                <td>
                    <span style="<?php echo $ml['status']=='Approved'?'color:green':($ml['status']=='Rejected'?'color:red':'color:orange'); ?>">
                        <?php echo $ml['status']; ?>
                    </span>
                </td>
                <td><?php echo htmlspecialchars($ml['reason']); ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
