<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    require_once __DIR__ . '/../src/Leave.php';
    $leave = new Leave();
    if ($leave->apply($_SESSION['user_id'], $_POST['type'], $_POST['start_date'], $_POST['end_date'], $_POST['reason'])) {
        echo "<script>window.location.href = 'index.php?action=leave';</script>";
        exit;
    }
}
?>
<div class="card" style="max-width: 600px; margin: 0 auto;">
    <h2>Apply for Leave</h2>
    <form method="POST">
        <div class="form-group">
            <label>Leave Type</label>
            <select name="type" class="form-control">
                <option value="Casual">Casual Leave</option>
                <option value="Sick">Sick Leave</option>
                <option value="Earned">Earned Leave</option>
            </select>
        </div>
        <div style="display: flex; gap: 1rem;">
            <div class="form-group" style="flex: 1;">
                <label>Start Date</label>
                <input type="date" name="start_date" required class="form-control">
            </div>
            <div class="form-group" style="flex: 1;">
                <label>End Date</label>
                <input type="date" name="end_date" required class="form-control">
            </div>
        </div>
        <div class="form-group">
            <label>Reason</label>
            <textarea name="reason" rows="3" required class="form-control"></textarea>
        </div>
        <button type="submit" style="background: #2563eb; color: white; padding: 10px 20px; border: none; border-radius: 4px; cursor: pointer; width: 100%;">Submit Application</button>
    </form>
</div>
