<div class="topbar-actions" style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem;">
    <h2>Employee Management</h2>
    <a href="index.php?action=employee_add" class="add-btn" style="background: #2563eb; color: white; padding: 8px 16px; text-decoration: none; border-radius: 4px;">+ Add New Employee</a>
</div>

<div class="card">
    <table style="width: 100%; border-collapse: collapse;">
        <thead>
            <tr style="background: #f9fafb; text-align: left;">
                <th style="padding: 12px; border-bottom: 1px solid #e5e7eb;">ID</th>
                <th style="padding: 12px; border-bottom: 1px solid #e5e7eb;">Name</th>
                <th style="padding: 12px; border-bottom: 1px solid #e5e7eb;">Designation</th>
                <th style="padding: 12px; border-bottom: 1px solid #e5e7eb;">Branch</th>
                <th style="padding: 12px; border-bottom: 1px solid #e5e7eb;">Status</th>
                <th style="padding: 12px; border-bottom: 1px solid #e5e7eb;">Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php
            require_once __DIR__ . '/../src/Employee.php';
            $emp = new Employee();
            // Determine viewing scope based on Role
            $branch_limit = null;
            if ($auth->hasRole('branch_manager')) {
                $branch_limit = $_SESSION['branch_id'];
            }
            $employees = $emp->getAll($branch_limit);
            
            foreach ($employees as $e):
            ?>
            <tr>
                <td style="padding: 12px; border-bottom: 1px solid #f3f4f6;"><?php echo htmlspecialchars($e['employee_id']); ?></td>
                <td style="padding: 12px; border-bottom: 1px solid #f3f4f6;">
                    <div style="font-weight: bold;"><?php echo htmlspecialchars($e['full_name']); ?></div>
                    <div style="font-size: 0.85rem; color: #6b7280;"><?php echo htmlspecialchars($e['email']); ?></div>
                </td>
                <td style="padding: 12px; border-bottom: 1px solid #f3f4f6;"><?php echo htmlspecialchars($e['designation']); ?></td>
                <td style="padding: 12px; border-bottom: 1px solid #f3f4f6;"><?php echo htmlspecialchars($e['branch_name'] ?? 'Head Office'); ?></td>
                <td style="padding: 12px; border-bottom: 1px solid #f3f4f6;">
                    <span style="padding: 4px 8px; border-radius: 12px; font-size: 0.8rem; background: #dcfce7; color: #166534;">
                        <?php echo htmlspecialchars($e['status']); ?>
                    </span>
                </td>
                <td style="padding: 12px; border-bottom: 1px solid #f3f4f6;">
                    <a href="index.php?action=employee_view&id=<?php echo $e['id']; ?>" style="color: #2563eb; margin-right: 10px;">View</a>
                    <?php if($auth->hasRole('hr_admin')): ?>
                    <a href="index.php?action=employee_edit&id=<?php echo $e['id']; ?>" style="color: #d97706;">Edit</a>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
