<?php
// Handle Form Submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    require_once __DIR__ . '/../src/Employee.php';
    $emp = new Employee();
    
    // Simple validation could go here
    
    $data = [
        'employee_id' => $_POST['employee_id'],
        'full_name' => $_POST['full_name'],
        'designation' => $_POST['designation'],
        'grade' => $_POST['grade'],
        'joining_date' => $_POST['joining_date'],
        'email' => $_POST['email'],
        'phone' => $_POST['phone'],
        'nid' => $_POST['nid'],
        'address' => $_POST['address'],
        'status' => $_POST['status'],
        'basic_salary' => $_POST['basic_salary']
    ];

    if ($emp->create($data)) {
        echo "<script>window.location.href = 'index.php?action=employees';</script>";
        exit;
    } else {
        $error = "Failed to create employee.";
    }
}
?>

<div class="card" style="max-width: 800px; margin: 0 auto;">
    <h2>Add New Employee</h2>
    
    <form method="POST" enctype="multipart/form-data">
        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem;">
            <div class="form-group">
                <label>Employee ID</label>
                <input type="text" name="employee_id" required class="form-control" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
            </div>
            
            <div class="form-group">
                <label>Full Name</label>
                <input type="text" name="full_name" required class="form-control" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
            </div>

            <div class="form-group">
                <label>Designation</label>
                <input type="text" name="designation" required class="form-control" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
            </div>

            <div class="form-group">
                <label>Grade (e.g. 10)</label>
                <input type="text" name="grade" class="form-control" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
            </div>

            <div class="form-group">
                <label>Status</label>
                <select name="status" class="form-control" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
                    <option value="Regular">Regular</option>
                    <option value="Probation" selected>Probation</option>
                    <option value="Project">Project</option>
                </select>
            </div>

            <div class="form-group">
                <label>Joining Date</label>
                <input type="date" name="joining_date" required class="form-control" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
            </div>
            
            <div class="form-group">
                <label>Basic Salary</label>
                <input type="number" name="basic_salary" step="0.01" class="form-control" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
            </div>

            <div class="form-group">
                <label>Email</label>
                <input type="email" name="email" class="form-control" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
            </div>
            
            <div class="form-group">
                <label>Phone</label>
                <input type="text" name="phone" class="form-control" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
            </div>

            <div class="form-group">
                <label>NID</label>
                <input type="text" name="nid" class="form-control" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
            </div>
        </div>

        <div class="form-group" style="margin-top: 1rem;">
            <label>Address</label>
            <textarea name="address" rows="3" class="form-control" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;"></textarea>
        </div>

        <div style="margin-top: 1.5rem; text-align: right;">
            <a href="index.php?action=employees" style="margin-right: 1rem; color: #6b7280; text-decoration: none;">Cancel</a>
            <button type="submit" style="background: #2563eb; color: white; padding: 10px 20px; border: none; border-radius: 4px; cursor: pointer;">Save Employee</button>
        </div>
    </form>
</div>
