<?php
require_once __DIR__ . '/../src/Attendance.php';
$att = new Attendance();
$date = isset($_GET['date']) ? $_GET['date'] : date('Y-m-d');
$branch_id = $_SESSION['branch_id'];

// Handle Submit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $attendance_data = [];
    foreach ($_POST['attendance'] as $eid => $val) {
        $attendance_data[$eid] = [
            'status' => isset($val['status']) ? 'Present' : 'Absent', // Checkbox logic
            'in_time' => !empty($val['in_time']) ? $val['in_time'] : null,
            'out_time' => !empty($val['out_time']) ? $val['out_time'] : null,
        ];
        // Explicit Status Override check
        if (!isset($val['status']) && (!empty($val['in_time']) || !empty($val['out_time']))) {
             $attendance_data[$eid]['status'] = 'Present';
        }
    }
    $att->markAttendance($date, $attendance_data);
    $success = "Attendance updated for " . $date;
}

$employees = $att->getDailyAttendance($branch_id, $date);
?>

<div class="card">
    <div style="display: flex; justify-content: space-between; margin-bottom: 20px;">
        <h2>Daily Attendance</h2>
        <form method="GET" action="index.php">
            <input type="hidden" name="action" value="attendance">
            <input type="date" name="date" value="<?php echo $date; ?>" onchange="this.form.submit()" style="padding: 8px;">
        </form>
    </div>

    <?php if(isset($success)): ?>
        <div style="background: #dcfce7; color: green; padding: 10px; margin-bottom: 10px; border-radius: 4px;"><?php echo $success; ?></div>
    <?php endif; ?>

    <form method="POST">
        <table>
            <thead>
                <tr>
                    <th>Emp ID</th>
                    <th>Name</th>
                    <th>Status</th>
                    <th>In Time</th>
                    <th>Out Time</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($employees as $e): ?>
                <tr>
                    <td><?php echo htmlspecialchars($e['emp_code']); ?></td>
                    <td><?php echo htmlspecialchars($e['full_name']); ?></td>
                    <td>
                        <label>
                            <input type="checkbox" name="attendance[<?php echo $e['employee_id']; ?>][status]" 
                                <?php echo ($e['status'] == 'Present') ? 'checked' : ''; ?>>
                            Present
                        </label>
                    </td>
                    <td>
                        <input type="time" name="attendance[<?php echo $e['employee_id']; ?>][in_time]" 
                               value="<?php echo htmlspecialchars($e['in_time'] ?? ''); ?>">
                    </td>
                    <td>
                        <input type="time" name="attendance[<?php echo $e['employee_id']; ?>][out_time]" 
                               value="<?php echo htmlspecialchars($e['out_time'] ?? ''); ?>">
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <div style="margin-top: 20px; text-align: right;">
            <button type="submit" style="background: #2563eb; color: white; padding: 10px 20px; border: none; border-radius: 4px; cursor: pointer;">Save Attendance</button>
        </div>
    </form>
</div>
