<?php
require_once __DIR__ . '/Database.php';

class Leave {
    private $conn;
    private $table = 'leave_applications';

    public function __construct() {
        $database = new Database();
        $this->conn = $database->getConnection();
    }

    public function apply($user_id, $type, $start_date, $end_date, $reason) {
        $query = "INSERT INTO " . $this->table . " 
                  (user_id, type, start_date, end_date, reason, status)
                  VALUES (:uid, :type, :start, :end, :reason, 'Pending')";
        
        $stmt = $this->conn->prepare($query);
        
        $stmt->bindParam(':uid', $user_id);
        $stmt->bindParam(':type', $type);
        $stmt->bindParam(':start', $start_date);
        $stmt->bindParam(':end', $end_date);
        $stmt->bindParam(':reason', $reason);

        return $stmt->execute();
    }

    public function getPendingLeaves($branch_id = null) {
        $query = "SELECT l.*, e.full_name, e.employee_id 
                  FROM " . $this->table . " l
                  JOIN users u ON l.user_id = u.id
                  LEFT JOIN employees e ON u.id = e.user_id
                  WHERE l.status = 'Pending'";
        
        if ($branch_id) {
            $query .= " AND u.branch_id = :branch_id";
        }
        
        $query .= " ORDER BY l.created_at DESC";
        
        $stmt = $this->conn->prepare($query);
        if ($branch_id) {
            $stmt->bindParam(':branch_id', $branch_id);
        }
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getMyLeaves($user_id) {
        $query = "SELECT * FROM " . $this->table . " 
                  WHERE user_id = :uid 
                  ORDER BY created_at DESC";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':uid', $user_id);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    
    public function approve($id, $approver_id) {
        $query = "UPDATE " . $this->table . " 
                  SET status = 'Approved', approved_by = :aid 
                  WHERE id = :id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':aid', $approver_id);
        $stmt->bindParam(':id', $id);
        return $stmt->execute();
    }

    public function reject($id, $approver_id) {
        $query = "UPDATE " . $this->table . " 
                  SET status = 'Rejected', approved_by = :aid 
                  WHERE id = :id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':aid', $approver_id);
        $stmt->bindParam(':id', $id);
        return $stmt->execute();
    }
}
