<?php
require_once __DIR__ . '/Database.php';

class Employee {
    private $conn;
    private $table = 'employees';

    public function __construct() {
        $database = new Database();
        $this->conn = $database->getConnection();
    }

    public function getAll($branch_id = null) {
        $query = "SELECT e.*, b.name as branch_name, r.name as role_name 
                  FROM " . $this->table . " e
                  LEFT JOIN users u ON e.user_id = u.id
                  LEFT JOIN branches b ON u.branch_id = b.id
                  LEFT JOIN roles r ON u.role_id = r.id";
        
        if ($branch_id) {
            $query .= " WHERE u.branch_id = :branch_id";
        }
        
        $query .= " ORDER BY e.id DESC";
        
        $stmt = $this->conn->prepare($query);
        if ($branch_id) {
            $stmt->bindParam(':branch_id', $branch_id);
        }
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function create($data) {
        $query = "INSERT INTO " . $this->table . " 
                  (employee_id, full_name, designation, grade, joining_date, email, phone, nid, address, status, basic_salary)
                  VALUES (:eid, :name, :desig, :grade, :jdate, :email, :phone, :nid, :addr, :status, :basic)";
        
        $stmt = $this->conn->prepare($query);
        
        // Bind parameters
        $stmt->bindParam(':eid', $data['employee_id']);
        $stmt->bindParam(':name', $data['full_name']);
        $stmt->bindParam(':desig', $data['designation']);
        $stmt->bindParam(':grade', $data['grade']);
        $stmt->bindParam(':jdate', $data['joining_date']);
        $stmt->bindParam(':email', $data['email']);
        $stmt->bindParam(':phone', $data['phone']);
        $stmt->bindParam(':nid', $data['nid']);
        $stmt->bindParam(':addr', $data['address']);
        $stmt->bindParam(':status', $data['status']);
        $stmt->bindParam(':basic', $data['basic_salary']);

        if($stmt->execute()) {
            return $this->conn->lastInsertId();
        }
        return false;
    }

    public function getById($id) {
        $query = "SELECT * FROM " . $this->table . " WHERE id = :id LIMIT 1";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }
}
