<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/Database.php';

class Auth {
    private $conn;
    private $table = 'users';

    public function __construct() {
        $database = new Database();
        $this->conn = $database->getConnection();
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }
    }

    public function login($username, $password) {
        $query = "SELECT u.id, u.username, u.password, u.role_id, r.name as role_name, r.slug as role_slug, u.branch_id 
                  FROM " . $this->table . " u 
                  JOIN roles r ON u.role_id = r.id 
                  WHERE u.username = :username LIMIT 1";
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':username', $username);
        $stmt->execute();
        
        if ($stmt->rowCount() > 0) {
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            if (password_verify($password, $row['password'])) {
                $_SESSION['user_id'] = $row['id'];
                $_SESSION['username'] = $row['username'];
                $_SESSION['role_id'] = $row['role_id'];
                $_SESSION['role_slug'] = $row['role_slug'];
                $_SESSION['branch_id'] = $row['branch_id'];
                return true;
            }
        }
        return false;
    }

    public function logout() {
        session_destroy();
        header("Location: " . APP_URL . "/index.php?action=login");
        exit;
    }

    public function isLoggedIn() {
        return isset($_SESSION['user_id']);
    }

    public function hasRole($role_slug) {
        return isset($_SESSION['role_slug']) && $_SESSION['role_slug'] === $role_slug;
    }

    public function getUser() {
        if ($this->isLoggedIn()) {
            return $_SESSION;
        }
        return null;
    }
    
    public function requireLogin() {
        if (!$this->isLoggedIn()) {
            header("Location: " . APP_URL . "/index.php?action=login");
            exit;
        }
    }
}
