<?php
require_once __DIR__ . '/Database.php';

class Attendance {
    private $conn;

    public function __construct() {
        $database = new Database();
        $this->conn = $database->getConnection();
    }

    public function markAttendance($date, $attendance_data) {
        // $attendance_data is an array [employee_id => status] or similar
        // For simplicity in this v1, we Delete existing for that day & branch (to allow updates) then Insert
        // Real-world: Insert on Duplicate Key Update
        
        $query = "INSERT INTO attendance (employee_id, date, status, in_time, out_time) 
                  VALUES (:eid, :date, :status, :in, :out)
                  ON DUPLICATE KEY UPDATE status=:status, in_time=:in, out_time=:out";
        
        $stmt = $this->conn->prepare($query);
        
        foreach ($attendance_data as $eid => $data) {
             $stmt->bindParam(':eid', $eid);
             $stmt->bindParam(':date', $date);
             $stmt->bindParam(':status', $data['status']);
             $stmt->bindParam(':in', $data['in_time']);
             $stmt->bindParam(':out', $data['out_time']);
             $stmt->execute();
        }
        return true;
    }
    
    public function getDailyAttendance($branch_id, $date) {
        // Get all employees of branch and join with attendance
        $query = "SELECT e.id as employee_id, e.full_name, e.employee_id as emp_code, a.status, a.in_time, a.out_time
                  FROM employees e
                  JOIN users u ON e.user_id = u.id
                  LEFT JOIN attendance a ON e.id = a.employee_id AND a.date = :date
                  WHERE u.branch_id = :branch_id
                  ORDER BY e.employee_id ASC";
                  
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':branch_id', $branch_id);
        $stmt->bindParam(':date', $date);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
