<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/src/Auth.php';

// Simple Router
$action = isset($_GET['action']) ? $_GET['action'] : 'dashboard';
$auth = new Auth();

// Handle Form Submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($action === 'login_submit') {
        $username = $_POST['username'];
        $password = $_POST['password'];
        if ($auth->login($username, $password)) {
            header("Location: index.php?action=dashboard");
            exit;
        } else {
            $error = "Invalid Credentials";
            include __DIR__ . '/templates/login.php';
            exit;
        }
    }
}

// Handle Page Views
switch ($action) {
    case 'login':
        include __DIR__ . '/templates/login.php';
        break;
        
    case 'logout':
        $auth->logout();
        break;

    case 'dashboard':
        $auth->requireLogin();
        $user = $auth->getUser(); // Ensure user is available for layout
        $content = __DIR__ . '/templates/dashboard_home.php';
        include __DIR__ . '/templates/layout.php';
        break;
        
    case 'employees':
        $auth->requireLogin();
        $user = $auth->getUser();
        $page_title = 'Employees';
        $content = __DIR__ . '/templates/employees.php';
        include __DIR__ . '/templates/layout.php';
        break;

    case 'employee_add':
        $auth->requireLogin();
        $user = $auth->getUser();
        $page_title = 'Add Employee';
        $content = __DIR__ . '/templates/employee_add.php';
        include __DIR__ . '/templates/layout.php';
        break;
        
    case 'branches':
        $auth->requireLogin();
        $user = $auth->getUser();
        $page_title = 'Branch Management';
        $content = __DIR__ . '/templates/branches.php';
        include __DIR__ . '/templates/layout.php';
        break;

    case 'branch_add':
        $auth->requireLogin();
        $user = $auth->getUser();
        $page_title = 'Add Branch';
        $content = __DIR__ . '/templates/branch_add.php';
        include __DIR__ . '/templates/layout.php';
        break;
        
    case 'leave':
        $auth->requireLogin();
        $user = $auth->getUser();
        $page_title = 'Leave Applications';
        $content = __DIR__ . '/templates/leave_list.php';
        include __DIR__ . '/templates/layout.php';
        break;

    case 'leave_apply':
        $auth->requireLogin();
        $user = $auth->getUser();
        $page_title = 'Apply Leave';
        $content = __DIR__ . '/templates/leave_apply.php';
        include __DIR__ . '/templates/layout.php';
        break;
        
    case 'attendance':
        $auth->requireLogin();
        // Role Check: Branch Manager Only
        /* if (!$auth->hasRole('branch_manager')) { ... } */
        $user = $auth->getUser();
        $page_title = 'Daily Attendance';
        $content = __DIR__ . '/templates/attendance.php';
        include __DIR__ . '/templates/layout.php';
        break;
        
    case 'payroll':
        $auth->requireLogin();
        $user = $auth->getUser();
        // Check Role
        $page_title = 'Monthly Salary Sheet';
        $content = __DIR__ . '/templates/payroll.php';
        include __DIR__ . '/templates/layout.php';
        break;

    case 'payroll_input':
        $auth->requireLogin();
        $user = $auth->getUser();
        $page_title = 'Variable Payroll Input';
        $content = __DIR__ . '/templates/payroll_input.php';
        include __DIR__ . '/templates/layout.php';
        break;

    case 'payroll_config':
        $auth->requireLogin();
        $user = $auth->getUser();
        $page_title = 'Payroll Configuration';
        $content = __DIR__ . '/templates/payroll_config.php';
        include __DIR__ . '/templates/layout.php';
        break;

    case 'payslips':
        $auth->requireLogin();
        $user = $auth->getUser();
        $page_title = 'My Payslip';
        $content = __DIR__ . '/templates/payslips.php';
        include __DIR__ . '/templates/layout.php';
        break;

    default:
        $auth->requireLogin();
        $user = $auth->getUser(); // Ensure user is available for layout
        $content = __DIR__ . '/templates/dashboard_home.php';
        include __DIR__ . '/templates/layout.php';
        break;
}
