<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/src/Database.php';

$db = new Database();
$conn = $db->getConnection();

$message = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Read Schema
        $sql = file_get_contents(__DIR__ . '/schema.sql');
        
        // Execute Schema (Split by ;)
        $conn->exec($sql);
        $message .= "Database tables created successfully.<br>";

        // Seed Default Admin User
        $password = password_hash('admin123', PASSWORD_BCRYPT);
        
        // Check if exists first
        $check = $conn->prepare("SELECT * FROM users WHERE username='admin'");
        $check->execute();
        
        if ($check->rowCount() == 0) {
            // Get ID for 'Super Admin' role
            $roleStmt = $conn->prepare("SELECT id FROM roles WHERE slug='super_admin' LIMIT 1");
            $roleStmt->execute();
            $roleData = $roleStmt->fetch(PDO::FETCH_ASSOC);
            $roleId = $roleData['id'];

            // Insert Super Admin
            $stmt = $conn->prepare("INSERT INTO users (username, password, role_id, status) VALUES ('admin', :pass, :role, 'active')");
            $stmt->bindParam(':pass', $password);
            $stmt->bindParam(':role', $roleId);
            $stmt->execute();
            
            $message .= "<strong>Default User Created:</strong><br>Username: admin<br>Password: admin123<br>";
        } else {
            $message .= "Default user 'admin' already exists.<br>";
        }

    } catch (Exception $e) {
        $message .= "Error: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Install AUP HR System</title>
    <style>
        body { font-family: sans-serif; padding: 50px; text-align: center; background: #f3f4f6; }
        .card { background: white; padding: 30px; border-radius: 8px; max-width: 500px; margin: 0 auto; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        .btn { background: #2563eb; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; border: none; font-size: 16px; cursor: pointer; }
        .success { color: green; background: #dcfce7; padding: 15px; border-radius: 5px; margin-bottom: 20px; text-align: left;}
    </style>
</head>
<body>
    <div class="card">
        <h1>AUP HR System Installer</h1>
        <p>This will create the database tables and a default admin user.</p>
        
        <?php if($message): ?>
            <div class="success"><?php echo $message; ?></div>
            <a href="public/index.php" class="btn">Go to Login</a>
        <?php else: ?>
            <form method="POST">
                <button type="submit" class="btn">Run Installation</button>
            </form>
        <?php endif; ?>
    </div>
</body>
</html>
